(
	-- Arch&Design Material

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			"019b2fab-058c-4877-8d02-e6c4b20ebe8f"
		)
		,
		fn GetMaps mtl context = 
		(
			local res = #()	

			if mtl.diffuse_weight > 0 do (
				if mtl.diff_color_map != undefined and mtl.diff_color_map_on do 
					append res #("diffuse", mtl.diff_color_map)
				if mtl.diff_rough_map != undefined and mtl.diff_rough_map_on do 
					append res #("diffuse_roughness", mtl.diff_rough_map, "resultFloat")
			)

			if mtl.refl_weight > 0 do (
				if mtl.refl_color_map != undefined and mtl.refl_color_map_on do 
					append res #("refl_color", mtl.refl_color_map)
				if mtl.refl_gloss_map != undefined and mtl.refl_gloss_map_on do 
					append res #("refl_gloss", mtl.refl_gloss_map, "resultFloat")

				if mtl.anisotropy_map != undefined and mtl.anisotropy_map_on do 
					append res #("anisotropy",  mtl.anisotropy_map, "resultFloat")
				if mtl.anisoangle_map != undefined and mtl.anisoangle_map_on do 
					append res #("angle",       mtl.anisoangle_map, "resultFloat")

				if mtl.aniso_mode == 1 do 
				(
					append res #("utangent", undefined, "u_tangent_" + (mtl.aniso_channel as String))
					append res #("vtangent", undefined, "v_tangent_" + (mtl.aniso_channel as String))
				)
			)

			if mtl.refr_weight > 0 do (
				if mtl.refr_color_map != undefined and mtl.refr_color_map_on do 
					append res #("refr_color", mtl.refr_color_map)
				if mtl.refl_gloss_map != undefined and mtl.refl_gloss_map_on do 
					append res #("refr_gloss", mtl.refr_gloss_map, "resultFloat")

				if mtl.refr_trans_on do (
					if mtl.refr_transc_map != undefined and mtl.refr_transc_map_on do 
						append res #("refr_transc", mtl.refr_transc_map)
					if mtl.refr_transw_map != undefined and mtl.refr_transw_map_on do 
						append res #("refr_transw", mtl.refr_transw_map, "resultFloat")
				)
			)

			if mtl.refr_ior_map != undefined and mtl.refr_ior_map_on do 
				append res #("refr_ior", mtl.refr_ior_map, "resultFloat")

			if mtl.bump_map != undefined and mtl.bump_map_on do 
				append res #("normal_perturb", mtl.bump_map, "normalPerturb", 1)

			if mtl.self_illum_on and mtl.self_illum_map != undefined and mtl.self_illum_map_on do 
				append res #("emission_filter", mtl.self_illum_map)
			if mtl.cutout_map != undefined and mtl.cutout_map_on do 
				append res #("cutout_opacity", mtl.cutout_map, "resultFloat")

			if mtl.add_color_map != undefined  and mtl.add_color_map_on do 
				append res #("additional_color", mtl.add_color_map)

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("diffuse",           mtl.diff_color)
			append res #("diffuse_weight",    mtl.diff_weight)
			append res #("diffuse_roughness", mtl.diff_rough)

			append res #("reflectivity",      mtl.refl_weight)
			if mtl.refl_weight > 0 do (
				append res #("refl_use_ior",      mtl.refl_func_fresnel)
				append res #("refl_exponent",     mtl.refl_func_curve)
				append res #("refl_curve_low",    mtl.refl_func_low)
				append res #("refl_curve_high",   mtl.refl_func_high)

				append res #("refl_color",        mtl.refl_color)
				append res #("refl_gloss",        mtl.refl_gloss)
				append res #("refl_is_metal",     mtl.refl_metal)
				append res #("anisotropy",        mtl.anisotropy)
				append res #("angle",             mtl.anisoangle)
			)

			append res #("thin_walled",       mtl.opts_1sided)

			append res #("transparency",      mtl.refr_weight) 
			if mtl.refr_weight > 0.0 do (
				append res #("refr_color",        mtl.refr_color)
				append res #("refr_gloss",        mtl.refr_gloss)

				if mtl.refr_trans_on do (
					append res #("refr_transc",  mtl.refr_transc)
					append res #("refr_transw",  mtl.refr_transw)
				)
			)

			append res #("refr_ior",          mtl.refr_ior)

			local emit = false

			if mtl.self_illum_on then (
				append res #("emission_filter",  mtl.self_illum_color_filter)
				append res #("emission",         mtl.EffectiveSelfIllum)
				emit = true
			)
			else
			(
				append res #("emission",  (color 0 0 0))
			)

			if mtl.add_color_map != undefined  and mtl.add_color_map_on do (
				emit = true
			)

			-- Commenting this out to fixx MAXX-48099, but leaving it here
			-- hoping it can be revisited in the future. The problem: The new ART makes objects
			-- non-shadow-casting if the emissive flag is set
			-- append res #("att:emissive", emit)
			
			append res #("no_diffuse_bump",  mtl.no_diffuse_bump)

			append res #("bump_amount",      mtl.bump_map_amt)

			append res #("cutout_opacity", 1.0) -- default to Opaque

			res
		)
	)

	AMGData()	
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAhOxftJnt3HvzWTWEV12JvwEy2x7s/3Uio
-- HNPcQ7GQcU8udXYRVdU2uTWfQXhdfD/i4ckkAE7/bnxx4DxrCs/nFAXsa3c9QnEY
-- IBAKVbsvLejOlRYcrZ8cNpUfCbwKQnBRqTks0N3HgA80wKbTu2SES6JTIGecyim3
-- nzFXV+/3NvYs0mXcoA+9SRq8q94cE621rSZiMdD6H8J4q8PqN45rBUekSEiXw63G
-- F2TWtTe4nuDBWj+HK7cPC0FeXWCbQu+xNePMRydNEr6X7jtxjF5AVcSU34MpinXH
-- XwdPUuaLto1x3gwNT7O6WekBrIbbiv+GS7fBJqiaeHJXbM9oj87a
-- -----END-SIGNATURE-----